# تعليمات نشر النظام على الاستضافة

## المشكلة
النظام يعيد صفحة التثبيت كل مرة على الاستضافة (park.meezmart.com)؟

## الحل

### 1️⃣ تشخيص المشكلة
1. احمل الملف `public/hosting-diagnostic.php` إلى الاستضافة
2. افتح الرابط: `https://park.meezmart.com/public/hosting-diagnostic.php`
3. تحقق من الإعدادات والاتصال

### 2️⃣ إصلاح سريع
1. احمل الملف `public/hosting-fix.php` إلى الاستضافة
2. افتح الرابط: `https://park.meezmart.com/public/hosting-fix.php`
3. اتبع التعليمات لإصلاح المشاكل

### 3️⃣ الإعدادات الصحيحة للاستضافة

**أهم نقطة:** يجب أن يكون لديك **ملف واحد فقط** للإعدادات:

```
✓ قم برفع:        .env
✓ قم برفع:        .env.example (كنسخة احتياطية)
✗ لا ترفع:         .env.local (هذا للتطوير المحلي فقط!)
```

### 4️⃣ محتوى .env الصحيح للاستضافة

ملف `.env` يجب أن يحتوي على إعدادات الاستضافة (meezmart):

```dotenv
APP_ENV=production
APP_URL=https://park.meezmart.com

# Database credentials from meezmart hosting panel
DB_DRIVER=mysql
DB_HOST=localhost
DB_PORT=3306
DB_NAME=meezma5_parking
DB_USER=meezma5_parking
DB_PASSWORD=Ahmedabass0110!
DB_CHARSET=utf8mb4

# Migration token (keep this)
MIGRATE_TOKEN=E8F4B1B6C2A94F3D9A7C1E5B2D4F6A8C0E2B1D3F5A7C9E1B3D5F7A9C1E3B5D7F9

# Twilio (leave empty if not using)
TWILIO_ACCOUNT_SID=
TWILIO_AUTH_TOKEN=
TWILIO_MESSAGING_SERVICE_SID=
TWILIO_WHATSAPP_ENABLED=false
ATTENDANT_PHONE=
```

### 5️⃣ خطوات الرفع الصحيحة

1. **احذف .env.local من حاسبك** (قبل الرفع)
   ```bash
   # تحقق أن .env.local موجود محلياً فقط وليس من المفترض رفعه
   ```

2. **رفع الملفات إلى الاستضافة** (عبر FTP أو File Manager):
   ```
   parking/
   ├── .env                 ← رفع بإعدادات meezmart
   ├── .env.example         ← رفع كنسخة احتياطية
   ├── .gitignore           ← تأكد من رفعها
   ├── public/
   │   ├── index.php
   │   ├── install.php
   │   ├── hosting-diagnostic.php  ← للتشخيص
   │   └── hosting-fix.php         ← للإصلاح
   ├── src/
   ├── database/
   └── ...
   ```

3. **تشغيل الإصلاح**:
   - افتح: `https://park.meezmart.com/public/hosting-diagnostic.php`
   - تحقق من الإعدادات
   - افتح: `https://park.meezmart.com/public/hosting-fix.php`
   - شغّل الإصلاح

### 6️⃣ التحقق النهائي

بعد الإصلاح، يجب أن ترى:
- ✅ `DB_HOST` = `localhost`
- ✅ `DB_NAME` = `meezma5_parking`
- ✅ `DB_USER` = `meezma5_parking`
- ✅ حالة النظام = `INSTALLED`

### 7️⃣ إذا استمرت المشكلة

**السبب الأكثر شيوعاً:** `.env.local` موجود على الاستضافة و يغطي إعدادات `.env`

**الحل:**
1. افتح: `https://park.meezmart.com/public/hosting-fix.php?action=remove-local`
2. سيحذف ملف `.env.local` من الاستضافة
3. أعد تحديث الصفحة الرئيسية

---

## ملاحظات مهمة

- ✅ ملف `.env` يحتوي على بيانات حساسة - **لا تنشره على GitHub**
- ✅ ملف `.env.local` للتطوير المحلي فقط - **اجعله في .gitignore**
- ✅ تأكد من أن قاعدة البيانات `meezma5_parking` موجودة على الاستضافة
- ✅ تأكد من أن اسم المستخدم وكلمة المرور صحيحة في لوحة التحكم
