<?php
use Parking\Auth;
use Parking\MigrationRunner;

$container = require __DIR__ . '/../bootstrap.php';
$database = $container['database'];
$config = $container['config'];

// Require admin login
$auth = new Auth($database);
$auth->requireAuth();

$ok = false;
$error = null;
try {
    $runner = new MigrationRunner($database, $config);
    $runner->run();
    $ok = true;
} catch (\Throwable $e) {
    $error = $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>تشغيل التعديلات على قاعدة البيانات</title>
  <link rel="stylesheet" href="assets/theme.css" />
  <link rel="stylesheet" href="assets/admin-dashboard.css" />
</head>
<body class="sidebar-fixed">
  <main class="main-content" style="max-width: 800px; margin: 40px auto;">
    <div class="card" style="padding: 24px;">
      <h1 style="margin-top: 0;">تشغيل تحديثات قاعدة البيانات</h1>
      <?php if ($ok): ?>
        <div class="alert alert-success" style="background: rgba(16, 185, 129, 0.1); border: 1px solid rgba(16, 185, 129, 0.3); color: var(--success); padding: 16px; border-radius: 12px; margin-bottom: 24px;">
          تم تنفيذ التحديثات بنجاح.
        </div>
      <?php else: ?>
        <div class="alert alert-danger" style="background: rgba(239, 68, 68, 0.12); border: 1px solid rgba(239, 68, 68, 0.35); color: #ef4444; padding: 16px; border-radius: 12px; margin-bottom: 24px;">
          حدث خطأ أثناء تنفيذ التحديثات: <?php echo htmlspecialchars($error ?? 'غير معروف'); ?>
        </div>
      <?php endif; ?>
      <div style="display:flex; gap: 12px;">
        <a class="btn" href="events.php">الرجوع لإدارة الإيفنتات</a>
        <a class="btn" href="coordinators.php">الرجوع لإدارة المنسقين</a>
        <a class="btn" href="admin-dashboard.php">الذهاب للوحة التحكم</a>
      </div>
      <p style="margin-top:16px; font-size:12px; color: var(--gray);">ملاحظة: يفضل حذف هذا الملف بعد نجاح التحديث.</p>
    </div>
  </main>
</body>
</html>
