<?php
// Must be the FIRST line - no output before this
require_once __DIR__ . '/session_init.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Advanced Session Debug</title>
</head>
<body>
<h1>Advanced Session Diagnostic</h1>
<pre><?php

echo "=== PHP SESSION INFO ===\n";
echo "Session ID: " . session_id() . "\n";
echo "Session Name: " . session_name() . "\n";
echo "Session Status: " . session_status() . " (1=disabled, 2=active)\n";
echo "Session Save Path: " . session_save_path() . "\n";
echo "Session Cookie Params:\n";
print_r(session_get_cookie_params());
echo "\n";

echo "=== SESSION DATA ===\n";
if (empty($_SESSION)) {
    echo "⚠ SESSION IS COMPLETELY EMPTY!\n";
    echo "This means either:\n";
    echo "  1. User never logged in\n";
    echo "  2. Session expired\n";
    echo "  3. Session file deleted\n";
    echo "  4. Session save path not writable\n";
} else {
    echo "Session contains:\n";
    foreach ($_SESSION as $key => $value) {
        echo "  [$key] => " . (is_array($value) ? json_encode($value) : $value) . "\n";
    }
}
echo "\n";

echo "=== COOKIES ===\n";
if (empty($_COOKIE)) {
    echo "No cookies found!\n";
} else {
    foreach ($_COOKIE as $name => $value) {
        if (strpos($name, 'SESS') !== false || $name === 'PARKINGSESSID') {
            echo "  $name = $value\n";
        }
    }
}
echo "\n";

echo "=== LOGIN CHECK ===\n";
if (isset($_SESSION['admin_id'])) {
    echo "✓ ADMIN IS LOGGED IN\n";
    echo "  Admin ID: " . $_SESSION['admin_id'] . "\n";
    echo "  Username: " . ($_SESSION['admin_username'] ?? 'N/A') . "\n";
    echo "  Full Name: " . ($_SESSION['admin_full_name'] ?? 'N/A') . "\n";
} elseif (isset($_SESSION['coordinator_id'])) {
    echo "✓ COORDINATOR IS LOGGED IN\n";
    echo "  Coordinator ID: " . $_SESSION['coordinator_id'] . "\n";
} else {
    echo "✗ NO USER LOGGED IN\n\n";
    
    echo "=== DIAGNOSIS ===\n";
    if (isset($_COOKIE['PARKINGSESSID'])) {
        echo "⚠ Cookie exists but session is empty!\n";
        echo "  Possible causes:\n";
        echo "  1. Session expired (check PHP session.gc_maxlifetime)\n";
        echo "  2. Session files cleared by server\n";
        echo "  3. Session.save_path permission issue\n";
        echo "  4. Different session.save_path between login and dashboard\n\n";
        
        echo "=== SESSION FILE CHECK ===\n";
        $sessionPath = session_save_path();
        if (empty($sessionPath)) {
            echo "⚠ Session save path is EMPTY (using system default)\n";
        } else {
            echo "Session path: $sessionPath\n";
            if (is_dir($sessionPath)) {
                echo "✓ Directory exists\n";
                if (is_writable($sessionPath)) {
                    echo "✓ Directory is writable\n";
                } else {
                    echo "✗ Directory is NOT writable!\n";
                }
            } else {
                echo "✗ Directory does NOT exist!\n";
            }
        }
    } else {
        echo "No cookie found - user never logged in\n";
    }
}

echo "\n=== PHP INFO ===\n";
echo "PHP Version: " . PHP_VERSION . "\n";
echo "Server: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "\n";
echo "Document Root: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Unknown') . "\n";

echo "\n=== RECOMMENDATIONS ===\n";
if (empty($_SESSION) && isset($_COOKIE['PARKINGSESSID'])) {
    echo "1. Try logging in again: <a href='login.php'>login.php</a>\n";
    echo "2. Clear browser cookies and try again\n";
    echo "3. Check server session settings (session.gc_maxlifetime)\n";
}

?></pre>
</body>
</html>
