/**
 * Sidebar Toggle Script
 * Handles mobile sidebar functionality
 */
(function() {
    const toggle = document.getElementById('sidebarToggle');
    const sidebar = document.querySelector('.sidebar');
    const backdrop = document.getElementById('sidebarBackdrop');
    
    if (!toggle || !sidebar || !backdrop) return;
    
    // Show toggle button on mobile
    function updateToggleVisibility() {
        if (window.innerWidth <= 768) {
            toggle.style.display = 'inline-flex';
        } else {
            toggle.style.display = 'none';
            // Close sidebar on desktop
            sidebar.classList.remove('open');
            backdrop.classList.remove('show');
        }
    }
    
    // Initial check
    updateToggleVisibility();
    
    // Update on resize
    window.addEventListener('resize', updateToggleVisibility);
    
    // Open/Close functions
    function openSidebar() {
        sidebar.classList.add('open');
        backdrop.classList.add('show');
        document.body.style.overflow = 'hidden'; // Prevent scroll
    }
    
    function closeSidebar() {
        sidebar.classList.remove('open');
        backdrop.classList.remove('show');
        document.body.style.overflow = ''; // Restore scroll
    }
    
    // Toggle button click
    toggle.addEventListener('click', function() {
        if (sidebar.classList.contains('open')) {
            closeSidebar();
        } else {
            openSidebar();
        }
    });
    
    // Backdrop click
    backdrop.addEventListener('click', closeSidebar);
    
    // Close on ESC key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && sidebar.classList.contains('open')) {
            closeSidebar();
        }
    });
    
    // Close sidebar when clicking a link on mobile
    const menuLinks = sidebar.querySelectorAll('.menu-link');
    menuLinks.forEach(function(link) {
        link.addEventListener('click', function() {
            if (window.innerWidth <= 768) {
                closeSidebar();
            }
        });
    });
})();
