<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Session Debug for Dashboard</h1>";
echo "<pre>";

echo "=== Step 1: Load session_init.php ===\n";
require_once __DIR__ . '/session_init.php';
echo "✓ Session loaded\n";
echo "Session ID: " . session_id() . "\n";
echo "Session Name: " . session_name() . "\n\n";

echo "=== Step 2: Session Contents ===\n";
if (empty($_SESSION)) {
    echo "⚠ SESSION IS EMPTY!\n";
} else {
    echo "Session data:\n";
    print_r($_SESSION);
}
echo "\n";

echo "=== Step 3: Check Login Status ===\n";
if (isset($_SESSION['admin_id'])) {
    echo "✓ Admin logged in (ID: " . $_SESSION['admin_id'] . ")\n";
} elseif (isset($_SESSION['coordinator_id'])) {
    echo "✓ Coordinator logged in (ID: " . $_SESSION['coordinator_id'] . ")\n";
} else {
    echo "✗ NO USER LOGGED IN\n";
    echo "   This is why you see 'انتهت جلستك'\n\n";
    
    echo "=== Possible Causes ===\n";
    echo "1. Session expired\n";
    echo "2. Cookies not working\n";
    echo "3. Different session path\n";
    echo "4. Session cleared by another page\n\n";
    
    echo "=== Cookie Info ===\n";
    if (isset($_COOKIE['PARKINGSESSID'])) {
        echo "✓ PARKINGSESSID cookie exists\n";
        echo "  Value: " . $_COOKIE['PARKINGSESSID'] . "\n";
    } else {
        echo "✗ PARKINGSESSID cookie NOT found\n";
    }
    
    if (isset($_COOKIE['PHPSESSID'])) {
        echo "  Old PHPSESSID: " . $_COOKIE['PHPSESSID'] . "\n";
    }
}

echo "\n=== Step 4: Test Auth Class ===\n";
try {
    $container = require __DIR__ . '/../bootstrap.php';
    $database = $container['database'];
    
    use Parking\Auth;
    $auth = new Auth($database);
    
    if ($auth->isLoggedIn()) {
        echo "✓ Auth says: User is logged in\n";
        echo "  Admin ID: " . $auth->getAdminId() . "\n";
        echo "  Full Name: " . $auth->getAdminFullName() . "\n";
    } else {
        echo "✗ Auth says: User is NOT logged in\n";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n=== Recommendation ===\n";
echo "Please LOGIN again at: login.php\n";
echo "Then come back to this page to verify session is working.\n";

echo "</pre>";
