<?php
// Force clear all sessions - NUCLEAR OPTION
if (session_status() === PHP_SESSION_ACTIVE) {
    session_destroy();
}

// Start fresh session
session_start();

// Clear ALL session data
$_SESSION = array();

// Destroy session
session_unset();
session_destroy();

// Clear session cookie with all possible paths
$cookieName = session_name();
$cookieParams = session_get_cookie_params();

// Try multiple paths to ensure cookie is deleted
setcookie($cookieName, '', time()-3600, '/');
setcookie($cookieName, '', time()-3600, '/parking/');
setcookie($cookieName, '', time()-3600, '/parking/public/');
setcookie($cookieName, '', time()-3600, $cookieParams['path']);

// Also try PARKINGSESSID if it exists
if (isset($_COOKIE['PARKINGSESSID'])) {
    setcookie('PARKINGSESSID', '', time()-3600, '/');
    setcookie('PARKINGSESSID', '', time()-3600, '/parking/');
    setcookie('PARKINGSESSID', '', time()-3600, '/parking/public/');
}

// Clear PHPSESSID as well
if (isset($_COOKIE['PHPSESSID'])) {
    setcookie('PHPSESSID', '', time()-3600, '/');
    setcookie('PHPSESSID', '', time()-3600, '/parking/');
    setcookie('PHPSESSID', '', time()-3600, '/parking/public/');
}

echo "<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Session Cleared</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 50px; text-align: center; background: #f5f5f5; }
        .box { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 500px; margin: 0 auto; }
        h1 { color: #28a745; }
        .btn { display: inline-block; padding: 12px 24px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; margin: 10px; }
        .btn:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class='box'>
        <h1>✓ تم حذف الجلسة بنجاح!</h1>
        <p>تم تسجيل الخروج من جميع الحسابات</p>
        <p>يمكنك الآن الوصول إلى الصفحات بشكل طبيعي</p>
        <br>
        <a href='index.php' class='btn'>الصفحة الرئيسية</a>
        <a href='login.php' class='btn'>تسجيل دخول Admin</a>
        <a href='coordinator-login.php' class='btn'>تسجيل دخول منسق</a>
    </div>
</body>
</html>";
