<?php
// Enable all error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "<h1>Events Page Diagnostic</h1>";
echo "<pre>";

try {
    echo "Step 1: Loading session_init.php...\n";
    require_once __DIR__ . '/session_init.php';
    echo "✓ Session initialized (Session ID: " . session_id() . ")\n\n";
    
    echo "Step 2: Session data:\n";
    print_r($_SESSION);
    echo "\n";
    
    echo "Step 3: Loading bootstrap...\n";
    $container = require __DIR__ . '/../bootstrap.php';
    $database = $container['database'];
    echo "✓ Bootstrap loaded\n\n";
    
    echo "Step 4: Testing database connection...\n";
    $pdo = $database->connection();
    echo "✓ Database connected (Driver: " . $pdo->getAttribute(PDO::ATTR_DRIVER_NAME) . ")\n\n";
    
    echo "Step 5: Creating Auth...\n";
    use Parking\Auth;
    use Parking\EventRepository;
    use Parking\ClientRepository;
    use Parking\Installer;
    
    $installer = new Installer(dirname(__DIR__));
    echo "✓ Installer created\n";
    
    if (!$installer->isInstalled($database)) {
        echo "⚠ Database not installed!\n";
        exit;
    }
    echo "✓ Database is installed\n\n";
    
    echo "Step 6: Creating Auth object...\n";
    $auth = new Auth($database);
    echo "✓ Auth object created\n";
    echo "  - Is logged in: " . ($auth->isLoggedIn() ? 'YES' : 'NO') . "\n";
    
    if (!$auth->isLoggedIn()) {
        echo "\n⚠ Not logged in - would redirect to login.php\n";
        echo "  Current session:\n";
        print_r($_SESSION);
    } else {
        echo "  - Admin ID: " . $auth->getAdminId() . "\n";
        echo "  - Admin Name: " . $auth->getAdminFullName() . "\n\n";
        
        echo "Step 7: Creating EventRepository...\n";
        $eventRepo = new EventRepository($database);
        echo "✓ EventRepository created\n\n";
        
        echo "Step 8: Creating ClientRepository...\n";
        $clientRepo = new ClientRepository($database);
        echo "✓ ClientRepository created\n\n";
        
        echo "Step 9: Getting active event...\n";
        $activeEvent = $eventRepo->getActiveEvent();
        if ($activeEvent) {
            echo "✓ Active event found: " . $activeEvent['name'] . "\n";
        } else {
            echo "ℹ No active event\n";
        }
        
        echo "\nStep 10: Getting all clients...\n";
        $clients = $clientRepo->getAllClients();
        echo "✓ Found " . count($clients) . " clients\n";
    }
    
    echo "\n=== ✓ ALL TESTS PASSED ===\n";
    
} catch (Exception $e) {
    echo "\n❌ ERROR OCCURRED:\n";
    echo "Message: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n\n";
    echo "Stack trace:\n";
    echo $e->getTraceAsString() . "\n";
}

echo "</pre>";
