<?php
/**
 * Parking Management System - Diagnostic Report
 * Provides detailed information about your hosting environment
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');

// Prevent caching
header('Content-Type: text/html; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Parking System - Diagnostic Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background: #f5f5f5;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        h1 { color: #333; border-bottom: 2px solid #007bff; padding-bottom: 10px; }
        h2 { color: #555; margin-top: 30px; margin-bottom: 15px; }
        .section { margin-bottom: 25px; }
        .pass { color: #28a745; font-weight: bold; }
        .fail { color: #dc3545; font-weight: bold; }
        .warn { color: #ffc107; font-weight: bold; }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th { background: #f8f9fa; font-weight: bold; }
        tr:hover { background: #f9f9f9; }
        .code {
            background: #f4f4f4;
            padding: 10px;
            border-radius: 4px;
            font-family: monospace;
            overflow-x: auto;
        }
        .alert {
            padding: 12px;
            margin: 10px 0;
            border-radius: 4px;
        }
        .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .alert-danger { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .alert-warning { background: #fff3cd; color: #856404; border: 1px solid #ffeeba; }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 10px;
        }
        .btn:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Parking System - Diagnostic Report</h1>
        <p>Generated: <?php echo date('Y-m-d H:i:s'); ?></p>

        <?php
        $projectRoot = dirname(dirname(__FILE__));
        $envFile = $projectRoot . '/.env';
        $dataDir = $projectRoot . '/data';
        $dbFile = $dataDir . '/parking.db';
        
        $status = [];
        $warnings = [];
        $errors = [];
        ?>

        <!-- PHP Information -->
        <div class="section">
            <h2>📊 Server Environment</h2>
            <table>
                <tr>
                    <th>Property</th>
                    <th>Value</th>
                    <th>Status</th>
                </tr>
                <tr>
                    <td>PHP Version</td>
                    <td><?php echo PHP_VERSION; ?></td>
                    <td>
                        <?php
                        if (version_compare(PHP_VERSION, '7.4.0', '>=')) {
                            echo '<span class="pass">✓ OK</span>';
                            $status['php'] = true;
                        } else {
                            echo '<span class="fail">✗ Too old</span>';
                            $errors[] = 'PHP 7.4 or later required';
                            $status['php'] = false;
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td>OS</td>
                    <td><?php echo php_uname(); ?></td>
                    <td>-</td>
                </tr>
                <tr>
                    <td>Web Server</td>
                    <td><?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></td>
                    <td>-</td>
                </tr>
            </table>
        </div>

        <!-- PHP Extensions -->
        <div class="section">
            <h2>🔌 Required Extensions</h2>
            <table>
                <tr>
                    <th>Extension</th>
                    <th>Status</th>
                    <th>Notes</th>
                </tr>
                <tr>
                    <td>PDO</td>
                    <td>
                        <?php
                        if (extension_loaded('pdo')) {
                            echo '<span class="pass">✓ Enabled</span>';
                            $status['pdo'] = true;
                        } else {
                            echo '<span class="fail">✗ Disabled</span>';
                            $errors[] = 'PDO extension not loaded';
                            $status['pdo'] = false;
                        }
                        ?>
                    </td>
                    <td>Database abstraction layer</td>
                </tr>
                <tr>
                    <td>PDO SQLite</td>
                    <td>
                        <?php
                        if (extension_loaded('pdo_sqlite')) {
                            echo '<span class="pass">✓ Enabled</span>';
                            $status['pdo_sqlite'] = true;
                        } else {
                            echo '<span class="fail">✗ Disabled</span>';
                            $errors[] = 'PDO SQLite driver not loaded';
                            $status['pdo_sqlite'] = false;
                        }
                        ?>
                    </td>
                    <td>Primary SQLite driver</td>
                </tr>
                <tr>
                    <td>SQLite3</td>
                    <td>
                        <?php
                        if (extension_loaded('sqlite3')) {
                            echo '<span class="pass">✓ Enabled</span>';
                            $status['sqlite3'] = true;
                        } else {
                            echo '<span class="warn">⚠ Disabled</span>';
                            $status['sqlite3'] = false;
                        }
                        ?>
                    </td>
                    <td>SQLite3 extension (from DB_Sqlite_Tools)</td>
                </tr>
                <tr>
                    <td>Legacy SQLite</td>
                    <td>
                        <?php
                        if (extension_loaded('sqlite')) {
                            echo '<span class="pass">✓ Enabled</span>';
                            $status['sqlite'] = true;
                        } else {
                            echo '<span class="warn">⚠ Disabled</span>';
                            $status['sqlite'] = false;
                        }
                        ?>
                    </td>
                    <td>Legacy SQLite extension (deprecated)</td>
                </tr>
                <tr>

            <?php if (!$status['pdo_sqlite'] ?? false): ?>
                <div class="alert alert-danger">
                    <strong>⚠️ Action Required:</strong> PDO SQLite is not enabled. Contact your hosting provider and ask them to enable the pdo_sqlite extension in php.ini.
                </div>
            <?php endif; ?>
        </div>

        <!-- File System -->
        <div class="section">
            <h2>📁 File System Permissions</h2>
            <table>
                <tr>
                    <th>Path</th>
                    <th>Status</th>
                    <th>Writable</th>
                    <th>Permissions</th>
                </tr>
                <tr>
                    <td><?php echo $projectRoot; ?></td>
                    <td>
                        <?php
                        if (is_dir($projectRoot)) {
                            echo '<span class="pass">✓ Exists</span>';
                        } else {
                            echo '<span class="fail">✗ Missing</span>';
                            $errors[] = 'Project root directory not found';
                        }
                        ?>
                    </td>
                    <td>
                        <?php
                        if (is_writable($projectRoot)) {
                            echo '<span class="pass">✓ Yes</span>';
                            $status['root_writable'] = true;
                        } else {
                            echo '<span class="fail">✗ No</span>';
                            $warnings[] = 'Project root not writable - Installation may fail';
                            $status['root_writable'] = false;
                        }
                        ?>
                    </td>
                    <td><?php echo decoct(fileperms($projectRoot) & 0777); ?></td>
                </tr>
                <tr>
                    <td><?php echo $dataDir; ?></td>
                    <td>
                        <?php
                        if (is_dir($dataDir)) {
                            echo '<span class="pass">✓ Exists</span>';
                        } else {
                            echo '<span class="warn">⚠ Missing</span>';
                            $warnings[] = 'Data directory will be created during installation';
                        }
                        ?>
                    </td>
                    <td>
                        <?php
                        if (is_dir($dataDir)) {
                            if (is_writable($dataDir)) {
                                echo '<span class="pass">✓ Yes</span>';
                                $status['data_writable'] = true;
                            } else {
                                echo '<span class="fail">✗ No</span>';
                                $errors[] = 'Data directory not writable';
                                $status['data_writable'] = false;
                            }
                        } else {
                            echo '-';
                        }
                        ?>
                    </td>
                    <td><?php echo is_dir($dataDir) ? decoct(fileperms($dataDir) & 0777) : 'N/A'; ?></td>
                </tr>
                <tr>
                    <td><?php echo $envFile; ?></td>
                    <td>
                        <?php
                        if (file_exists($envFile)) {
                            echo '<span class="pass">✓ Exists</span>';
                            $status['env_exists'] = true;
                        } else {
                            echo '<span class="warn">⚠ Missing</span>';
                            $warnings[] = '.env file will be created during installation';
                            $status['env_exists'] = false;
                        }
                        ?>
                    </td>
                    <td>
                        <?php
                        if (file_exists($envFile)) {
                            echo is_writable($envFile) ? '<span class="pass">✓ Yes</span>' : '<span class="fail">✗ No</span>';
                        } else {
                            echo '-';
                        }
                        ?>
                    </td>
                    <td><?php echo file_exists($envFile) ? decoct(fileperms($envFile) & 0777) : 'N/A'; ?></td>
                </tr>
                <tr>
                    <td><?php echo $dbFile; ?></td>
                    <td>
                        <?php
                        if (file_exists($dbFile)) {
                            echo '<span class="pass">✓ Exists</span>';
                            $status['db_exists'] = true;
                        } else {
                            echo '<span class="warn">⚠ Missing</span>';
                            $warnings[] = 'Database will be created during installation';
                            $status['db_exists'] = false;
                        }
                        ?>
                    </td>
                    <td>
                        <?php
                        if (file_exists($dbFile)) {
                            echo is_writable($dbFile) ? '<span class="pass">✓ Yes</span>' : '<span class="fail">✗ No</span>';
                        } else {
                            echo '-';
                        }
                        ?>
                    </td>
                    <td><?php echo file_exists($dbFile) ? (filesize($dbFile) . ' bytes') : 'N/A'; ?></td>
                </tr>
            </table>
        </div>

        <!-- Configuration -->
        <div class="section">
            <h2>⚙️ Configuration</h2>
            <?php if (file_exists($envFile)): ?>
                <p><span class="pass">✓ .env file detected</span></p>
                <div class="code">
                    <?php
                    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                    foreach ($lines as $line) {
                        if (strpos($line, '=') !== false) {
                            list($key, $value) = explode('=', $line, 2);
                            // Hide sensitive values
                            if (in_array($key, ['TWILIO_AUTH_TOKEN', 'TWILIO_ACCOUNT_SID'])) {
                                $value = '***HIDDEN***';
                            }
                            echo htmlspecialchars($key) . '=' . htmlspecialchars($value) . '<br>';
                        }
                    }
                    ?>
                </div>
            <?php else: ?>
                <div class="alert alert-warning">
                    <strong>ℹ️ Info:</strong> .env file not found. Run the installation wizard to create it.
                </div>
            <?php endif; ?>
        </div>

        <!-- Summary -->
        <div class="section">
            <h2>📋 Summary</h2>
            
            <!-- SQLite Method Detection -->
            <?php
            $sqliteMethods = [];
            $recommendedMethod = '';
            
            if ($status['pdo_sqlite'] ?? false) {
                $sqliteMethods[] = 'PDO SQLite';
                if (!$recommendedMethod) $recommendedMethod = 'PDO SQLite';
            }
            if ($status['sqlite3'] ?? false) {
                $sqliteMethods[] = 'SQLite3 (DB_Sqlite_Tools)';
                if (!$recommendedMethod) $recommendedMethod = 'SQLite3 (DB_Sqlite_Tools)';
            }
            if ($status['sqlite'] ?? false) {
                $sqliteMethods[] = 'Legacy SQLite';
                if (!$recommendedMethod) $recommendedMethod = 'Legacy SQLite';
            }
            
            if (!empty($sqliteMethods)):
            ?>
                <div class="alert alert-success">
                    <strong>✓ SQLite Support Detected:</strong><br>
                    Available methods: <?php echo implode(', ', $sqliteMethods); ?><br>
                    Recommended: <strong><?php echo $recommendedMethod; ?></strong>
                </div>
            <?php endif; ?>
            
            <?php if (empty($errors) && empty($warnings)): ?>
                <div class="alert alert-success">
                    <strong>✓ All systems go!</strong> Your hosting environment meets all requirements. You can proceed with installation.
                </div>
            <?php elseif (empty($errors)): ?>
                <div class="alert alert-warning">
                    <strong>⚠️ Warnings:</strong>
                    <ul>
                        <?php foreach ($warnings as $warning): ?>
                            <li><?php echo htmlspecialchars($warning); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php else: ?>
                <div class="alert alert-danger">
                    <strong>✗ Errors Found:</strong>
                    <ul>
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo htmlspecialchars($error); ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <p>Please contact your hosting provider with these error messages.</p>
                </div>
            <?php endif; ?>

            <?php if (empty($errors)): ?>
                <a href="install.php" class="btn">Continue to Installation →</a>
            <?php endif; ?>
        </div>

        <hr style="margin-top: 40px; opacity: 0.3;">
        <p style="text-align: center; color: #666; font-size: 12px;">
            Diagnostic Report Generated on <?php echo date('Y-m-d H:i:s'); ?><br>
            For support, visit: <a href="mailto:support@example.com">support@example.com</a>
        </p>
    </div>
</body>
</html>
