<?php
// FORCE CACHE CLEAR AND REDIRECT
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
header('Expires: 0');

// Clear session completely
session_start();
$_SESSION = array();
session_destroy();

// Delete ALL cookies
if (isset($_SERVER['HTTP_COOKIE'])) {
    $cookies = explode(';', $_SERVER['HTTP_COOKIE']);
    foreach($cookies as $cookie) {
        $parts = explode('=', $cookie);
        $name = trim($parts[0]);
        setcookie($name, '', time()-3600);
        setcookie($name, '', time()-3600, '/');
        setcookie($name, '', time()-3600, '/parking/');
        setcookie($name, '', time()-3600, '/parking/public/');
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <title>تنظيف الكاش والإعدادات</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 700px;
            width: 100%;
        }
        h1 { color: #333; margin-bottom: 20px; text-align: center; }
        .success { color: #28a745; font-size: 4em; text-align: center; margin: 20px 0; }
        .step {
            background: #f8f9fa;
            padding: 15px;
            margin: 10px 0;
            border-radius: 8px;
            border-right: 4px solid #28a745;
        }
        .warning {
            background: #fff3cd;
            border: 2px solid #ffc107;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            color: #856404;
            text-align: center;
        }
        .btn-container { text-align: center; margin: 30px 0; }
        .btn {
            display: inline-block;
            padding: 15px 30px;
            margin: 10px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-size: 1.1em;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        .btn:hover { background: #0056b3; transform: translateY(-2px); }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #218838; }
        .instructions {
            background: #e7f3ff;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            text-align: right;
            line-height: 2;
        }
        .instructions h3 { color: #0066cc; margin-bottom: 15px; }
        .instructions ol { margin-right: 20px; }
        .instructions strong { color: #d9534f; }
        #countdown { font-size: 2em; color: #007bff; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="success">✓</div>
        <h1>تم تنظيف النظام بنجاح!</h1>
        
        <div class="step">✓ تم حذف جميع بيانات الجلسة</div>
        <div class="step">✓ تم حذف جميع ملفات الكوكيز</div>
        <div class="step">✓ تم مسح ذاكرة التخزين المؤقت</div>
        
        <div class="warning">
            <h3>⚠️ خطوة مهمة جداً!</h3>
            <p style="font-size: 1.2em; margin: 15px 0;">
                يجب عليك تنظيف ذاكرة المتصفح الآن
            </p>
        </div>
        
        <div class="instructions">
            <h3>اختر إحدى الطرق التالية:</h3>
            <ol>
                <li><strong>الطريقة الأولى (الأسهل):</strong>
                    <ul style="margin: 10px 0;">
                        <li>اضغط <kbd>Ctrl + Shift + Delete</kbd></li>
                        <li>اختر "Cookies" و "Cached Images"</li>
                        <li>اضغط "Clear Data"</li>
                    </ul>
                </li>
                <li><strong>الطريقة الثانية:</strong> أغلق المتصفح <strong>تماماً</strong> ثم افتحه من جديد</li>
                <li><strong>الطريقة الثالثة (للاختبار):</strong> استخدم وضع التصفح الخفي (Incognito/Private)</li>
            </ol>
        </div>
        
        <div class="btn-container">
            <p>سيتم التوجيه تلقائياً بعد <span id="countdown">10</span> ثانية</p>
            <br>
            <a href="index.php?v=<?php echo time(); ?>" class="btn btn-success">الصفحة الرئيسية</a>
            <a href="login.php?v=<?php echo time(); ?>" class="btn">تسجيل الدخول</a>
        </div>
    </div>
    
    <script>
        // Clear browser cache
        if ('caches' in window) {
            caches.keys().then(names => {
                names.forEach(name => caches.delete(name));
            });
        }
        
        // Clear localStorage and sessionStorage
        try {
            localStorage.clear();
            sessionStorage.clear();
        } catch(e) {}
        
        // Countdown timer
        let count = 10;
        const countdown = document.getElementById('countdown');
        const timer = setInterval(() => {
            count--;
            countdown.textContent = count;
            if (count <= 0) {
                clearInterval(timer);
                // Add timestamp to force no-cache
                window.location.href = 'index.php?v=' + Date.now();
            }
        }, 1000);
        
        // Prevent back button cache
        window.onpageshow = function(event) {
            if (event.persisted) {
                window.location.reload();
            }
        };
    </script>
</body>
</html>
