<?php
// Ultimate diagnostic - check EVERYTHING
error_reporting(0);
ob_start();

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'>";
echo "<meta http-equiv='Cache-Control' content='no-cache, no-store, must-revalidate'>";
echo "<meta http-equiv='Pragma' content='no-cache'>";
echo "<meta http-equiv='Expires' content='0'>";
echo "<title>Full System Check</title>";
echo "<style>
body{font-family:monospace;padding:20px;background:#1a1a1a;color:#fff;}
.section{background:#2a2a2a;padding:15px;margin:10px 0;border-radius:5px;border-left:4px solid #0066cc;}
.error{border-left-color:#cc0000;background:#3a1a1a;}
.success{border-left-color:#00cc66;background:#1a3a1a;}
.warning{border-left-color:#ffaa00;background:#3a2a1a;}
h1{color:#00aaff;}
h2{color:#00ff88;margin-top:20px;}
pre{background:#000;padding:10px;overflow:auto;color:#0f0;}
a{color:#00aaff;text-decoration:none;padding:5px 10px;background:#0066cc;border-radius:3px;display:inline-block;margin:5px;}
a:hover{background:#0088ff;}
</style></head><body>";

echo "<h1>🔍 FULL SYSTEM DIAGNOSTIC</h1>";
echo "<p>Time: " . date('Y-m-d H:i:s') . "</p>";

// 1. Check PHP Headers
echo "<h2>1. PHP Headers Status</h2>";
echo "<div class='section'>";
if (headers_sent($file, $line)) {
    echo "<div class='error'>❌ Headers already sent at $file:$line</div>";
} else {
    echo "<div class='success'>✓ Headers not sent yet (good)</div>";
}
echo "</div>";

// 2. Check Session
echo "<h2>2. Session Status</h2>";
echo "<div class='section'>";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "Session Status: <strong>ACTIVE</strong><br>";
    echo "Session ID: " . session_id() . "<br>";
} else {
    session_start();
    echo "Session Status: <strong>Started Now</strong><br>";
    echo "Session ID: " . session_id() . "<br>";
}
echo "Session Data:<pre>" . print_r($_SESSION, true) . "</pre>";
if (isset($_SESSION['admin_id'])) {
    echo "<div class='error'>❌ ADMIN SESSION FOUND! ID: " . $_SESSION['admin_id'] . "</div>";
    echo "<a href='clear-session.php'>Clear Session Now</a>";
}
echo "</div>";

// 3. Check Files
echo "<h2>3. Critical Files Check</h2>";
$files = [
    'index.php' => __DIR__ . '/index.php',
    'login.php' => __DIR__ . '/login.php',
    'admin-dashboard.php' => __DIR__ . '/admin-dashboard.php',
    'bootstrap.php' => dirname(__DIR__) . '/bootstrap.php',
    '.env' => dirname(__DIR__) . '/.env',
];

foreach ($files as $name => $path) {
    echo "<div class='section'>";
    echo "<strong>$name:</strong> ";
    if (file_exists($path)) {
        echo "✓ EXISTS (" . filesize($path) . " bytes)<br>";
        
        // Check for redirects in PHP files
        if (pathinfo($name, PATHINFO_EXTENSION) === 'php') {
            $content = file_get_contents($path);
            if (preg_match('/header\s*\(\s*[\'"]Location:\s*admin-dashboard\.php/i', $content)) {
                echo "<div class='error'>❌ FOUND REDIRECT TO admin-dashboard.php in this file!</div>";
                // Show the line
                $lines = explode("\n", $content);
                foreach ($lines as $num => $line) {
                    if (stripos($line, 'admin-dashboard.php') !== false) {
                        echo "Line " . ($num + 1) . ": <code>" . htmlspecialchars($line) . "</code><br>";
                    }
                }
            }
        }
    } else {
        echo "❌ NOT FOUND";
    }
    echo "</div>";
}

// 4. Check .htaccess
echo "<h2>4. .htaccess Files</h2>";
$htaccess_files = [
    'Root' => $_SERVER['DOCUMENT_ROOT'] . '/.htaccess',
    'Parking' => dirname(__DIR__) . '/.htaccess',
    'Public' => __DIR__ . '/.htaccess',
];

foreach ($htaccess_files as $location => $path) {
    echo "<div class='section'>";
    echo "<strong>$location:</strong> $path<br>";
    if (file_exists($path)) {
        $content = file_get_contents($path);
        echo "✓ EXISTS (" . strlen($content) . " bytes)<br>";
        if (empty(trim($content))) {
            echo "<div class='warning'>⚠️ FILE IS EMPTY!</div>";
        } else {
            if (stripos($content, 'admin-dashboard') !== false) {
                echo "<div class='error'>❌ Contains 'admin-dashboard'!</div>";
            }
            echo "<pre>" . htmlspecialchars($content) . "</pre>";
        }
    } else {
        echo "Not found";
    }
    echo "</div>";
}

// 5. Check Server Variables
echo "<h2>5. Server Variables</h2>";
echo "<div class='section'><pre>";
$important = ['HTTP_HOST', 'REQUEST_URI', 'SCRIPT_NAME', 'DOCUMENT_ROOT', 'REDIRECT_URL', 'REDIRECT_STATUS', 'SERVER_SOFTWARE'];
foreach ($important as $var) {
    echo "$var: " . ($_SERVER[$var] ?? 'N/A') . "\n";
}
echo "</pre></div>";

// 6. Test Direct Access
echo "<h2>6. Direct Access Test</h2>";
echo "<div class='section'>";
echo "<p>Try accessing these URLs directly:</p>";
$testUrls = [
    'index.php' => 'Main Page',
    'login.php' => 'Admin Login',
    'test.php' => 'Simple Test',
];
foreach ($testUrls as $url => $desc) {
    echo "<a href='$url?nocache=" . time() . "' target='_blank'>$url</a> - $desc<br>";
}
echo "</div>";

// 7. PHP Info
echo "<h2>7. PHP Configuration</h2>";
echo "<div class='section'>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Loaded Extensions: " . implode(', ', get_loaded_extensions()) . "<br>";
echo "</div>";

echo "</body></html>";

$output = ob_get_clean();
echo $output;
