<?php
// Home page - NO authentication required
require_once __DIR__ . '/session_init.php';

$isLoggedIn = isset($_SESSION['admin_id']) || isset($_SESSION['coordinator_id']);
$isAdmin = isset($_SESSION['admin_id']);
$isCoordinator = isset($_SESSION['coordinator_id']);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام الباركنج - شركة الخليج للسيارات</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800;900&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
        *, *::before, *::after { margin: 0; padding: 0; box-sizing: border-box; }
        
        :root {
            --brand-primary: #6C63FF;
            --brand-secondary: #00D9A6;
            --brand-gradient: linear-gradient(135deg, #6C63FF 0%, #00D9A6 100%);
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background: #0B0E14;
            min-height: 100vh;
            color: #F0F2F5;
            overflow-x: hidden;
        }
        
        /* Animated gradient background */
        .hero-bg {
            position: fixed;
            inset: 0;
            z-index: 0;
            overflow: hidden;
        }
        .hero-bg::before {
            content: '';
            position: absolute;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(108,99,255,0.15) 0%, transparent 70%);
            top: -200px;
            right: -200px;
            animation: float 8s ease-in-out infinite;
        }
        .hero-bg::after {
            content: '';
            position: absolute;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(0,217,166,0.1) 0%, transparent 70%);
            bottom: -150px;
            left: -150px;
            animation: float 10s ease-in-out infinite reverse;
        }
        @keyframes float {
            0%, 100% { transform: translate(0, 0); }
            50% { transform: translate(30px, -30px); }
        }
        
        .page-wrap {
            position: relative;
            z-index: 1;
            max-width: 1100px;
            margin: 0 auto;
            padding: 60px 24px;
        }
        
        /* Header */
        .hero-header {
            text-align: center;
            margin-bottom: 60px;
        }
        .hero-logo {
            width: 80px;
            height: 80px;
            background: var(--brand-gradient);
            border-radius: 22px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
            box-shadow: 0 12px 40px rgba(108, 99, 255, 0.3);
        }
        .hero-logo .material-icons { font-size: 44px; color: #fff; }
        .hero-title {
            font-size: 3rem;
            font-weight: 900;
            background: var(--brand-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 12px;
        }
        .hero-subtitle {
            font-size: 1.25rem;
            color: #8B95A8;
            font-weight: 500;
        }
        
        /* Status banner */
        .status-banner {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            padding: 14px 24px;
            margin-bottom: 48px;
            background: rgba(0, 217, 166, 0.08);
            border: 1px solid rgba(0, 217, 166, 0.2);
            border-radius: 14px;
            color: var(--brand-secondary);
            font-weight: 700;
            font-size: 15px;
        }
        .status-banner .material-icons { font-size: 22px; }
        
        /* Logged-in banner */
        .logged-in-bar {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            flex-wrap: wrap;
            padding: 18px 24px;
            margin-bottom: 48px;
            background: rgba(108, 99, 255, 0.06);
            border: 1px solid rgba(108, 99, 255, 0.15);
            border-radius: 14px;
        }
        .logged-in-bar span { color: #8B95A8; font-weight: 600; }
        
        /* Cards Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 24px;
            margin-bottom: 48px;
        }
        .feature-card {
            background: #111520;
            border: 1px solid rgba(255,255,255,0.06);
            border-radius: 20px;
            padding: 36px 28px;
            text-align: center;
            transition: all 0.35s ease;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }
        .feature-card::before {
            content: '';
            position: absolute;
            inset: 0;
            background: var(--brand-gradient);
            opacity: 0;
            transition: opacity 0.35s;
            z-index: 0;
        }
        .feature-card:hover {
            border-color: rgba(108, 99, 255, 0.3);
            transform: translateY(-6px);
            box-shadow: 0 16px 48px rgba(108, 99, 255, 0.15);
        }
        .feature-card:hover::before { opacity: 0.04; }
        .feature-card > * { position: relative; z-index: 1; }
        .card-icon {
            width: 64px;
            height: 64px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 32px;
        }
        .card-icon.purple { background: rgba(108,99,255,0.12); color: var(--brand-primary); }
        .card-icon.green { background: rgba(0,217,166,0.12); color: var(--brand-secondary); }
        .card-icon.amber { background: rgba(255,183,77,0.12); color: #FFB74D; }
        .feature-card h3 {
            font-size: 1.3rem;
            font-weight: 800;
            color: #F0F2F5;
            margin-bottom: 10px;
        }
        .feature-card p {
            color: #8B95A8;
            font-size: 14px;
            line-height: 1.7;
            margin-bottom: 20px;
        }
        
        /* Buttons */
        .btn-brand {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 28px;
            background: var(--brand-gradient);
            color: #fff;
            text-decoration: none;
            border-radius: 12px;
            font-family: 'Tajawal', sans-serif;
            font-weight: 700;
            font-size: 14px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn-brand:hover {
            transform: scale(1.04);
            box-shadow: 0 8px 24px rgba(108, 99, 255, 0.35);
        }
        .btn-outline {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 28px;
            background: transparent;
            color: var(--brand-primary);
            text-decoration: none;
            border-radius: 12px;
            font-family: 'Tajawal', sans-serif;
            font-weight: 700;
            font-size: 14px;
            border: 2px solid rgba(108,99,255,0.3);
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn-outline:hover {
            background: rgba(108,99,255,0.08);
            border-color: var(--brand-primary);
        }
        .btn-danger {
            background: rgba(239,68,68,0.12);
            color: #ef4444;
            border: 1px solid rgba(239,68,68,0.2);
        }
        .btn-danger:hover {
            background: rgba(239,68,68,0.2);
        }
        
        /* Footer */
        .page-footer {
            text-align: center;
            padding: 24px;
            color: #5A6478;
            font-size: 13px;
        }
        .page-footer strong { color: #8B95A8; }
        
        @media (max-width: 768px) {
            .hero-title { font-size: 2rem; }
            .cards-grid { grid-template-columns: 1fr; }
            .page-wrap { padding: 40px 16px; }
        }
    </style>
</head>
<body>
    <div class="hero-bg"></div>
    
    <div class="page-wrap">
        <div class="hero-header">
            <div class="hero-logo">
                <span class="material-icons">local_parking</span>
            </div>
            <h1 class="hero-title">نظام الباركنج</h1>
            <p class="hero-subtitle">شركة الخليج للسيارات - نظام إدارة المواقف</p>
        </div>
        
        <div class="status-banner">
            <span class="material-icons">check_circle</span>
            النظام جاهز للعمل
        </div>
        
        <?php if ($isLoggedIn): ?>
            <div class="logged-in-bar">
                <span class="material-icons" style="color: var(--brand-secondary);">verified</span>
                <span><?php echo $isAdmin ? 'مرحباً بك في لوحة الإدارة' : 'مرحباً بك أيها المنسق'; ?></span>
                <a href="<?php echo $isAdmin ? 'admin-dashboard.php' : 'coordinator-dashboard.php'; ?>" class="btn-brand" style="margin-right: auto;">
                    <span class="material-icons" style="font-size: 18px;">dashboard</span>
                    لوحة التحكم
                </a>
                <a href="<?php echo $isAdmin ? 'logout.php' : 'coordinator-logout.php'; ?>" class="btn-outline btn-danger" style="padding: 10px 20px;">
                    <span class="material-icons" style="font-size: 18px;">logout</span>
                    خروج
                </a>
            </div>
        <?php endif; ?>
        
        <div class="cards-grid">
            <div class="feature-card" onclick="location.href='register-vehicle.php'">
                <div class="card-icon purple">
                    <span class="material-icons">directions_car</span>
                </div>
                <h3>تسجيل مركبة</h3>
                <p>سجّل مركبة جديدة في النظام بسهولة وسرعة مع إرسال رابط الطلب للعميل</p>
                <a href="register-vehicle.php" class="btn-brand">
                    <span class="material-icons" style="font-size: 18px;">add_circle</span>
                    تسجيل الآن
                </a>
            </div>
            
            <?php if (!$isLoggedIn): ?>
            <div class="feature-card" onclick="location.href='login.php'">
                <div class="card-icon green">
                    <span class="material-icons">admin_panel_settings</span>
                </div>
                <h3>لوحة الإدارة</h3>
                <p>دخول المسؤولين لإدارة النظام والفعاليات والمنسقين</p>
                <a href="login.php" class="btn-brand">
                    <span class="material-icons" style="font-size: 18px;">login</span>
                    دخول الإدارة
                </a>
            </div>
            
            <div class="feature-card" onclick="location.href='coordinator-login.php'">
                <div class="card-icon amber">
                    <span class="material-icons">badge</span>
                </div>
                <h3>المنسقون</h3>
                <p>دخول المنسقين لتسجيل السيارات ومتابعة الفعاليات</p>
                <a href="coordinator-login.php" class="btn-brand">
                    <span class="material-icons" style="font-size: 18px;">login</span>
                    دخول منسق
                </a>
            </div>
            <?php else: ?>
            <div class="feature-card" onclick="location.href='dashboard.php'">
                <div class="card-icon green">
                    <span class="material-icons">monitor_heart</span>
                </div>
                <h3>الشاشة المباشرة</h3>
                <p>متابعة حالات السيارات لحظة بلحظة مع إشعارات فورية</p>
                <a href="dashboard.php" class="btn-brand">
                    <span class="material-icons" style="font-size: 18px;">visibility</span>
                    متابعة الآن
                </a>
            </div>
            
            <?php if ($isAdmin): ?>
            <div class="feature-card" onclick="location.href='events.php'">
                <div class="card-icon amber">
                    <span class="material-icons">celebration</span>
                </div>
                <h3>الفعاليات</h3>
                <p>إدارة الفعاليات والعملاء والمنسقين بسهولة</p>
                <a href="events.php" class="btn-brand">
                    <span class="material-icons" style="font-size: 18px;">arrow_forward</span>
                    إدارة الفعاليات
                </a>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>
        
        <div class="page-footer">
            <strong>شركة الخليج</strong> &middot; نظام الباركنج &middot; الإصدار 1.0
        </div>
    </div>
</body>
</html>
