<?php
/**
 * Hosting Fix Script
 * 
 * هذا الملف يحل مشاكل التثبيت على الاستضافة:
 * 1. ينسخ .env من الأصل إذا كان مفقوداً
 * 2. يحذف .env.local إذا كان موجوداً (يجب أن يكون محلياً فقط)
 * 3. يعيد تشغيل الترحيلات
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

$baseDir = dirname(__DIR__);
$envFile = $baseDir . '/.env';
$envLocalFile = $baseDir . '/.env.local';
$envExampleFile = $baseDir . '/.env.example';

echo "<!DOCTYPE html>
<html lang='ar' dir='rtl'>
<head>
    <meta charset='UTF-8'>
    <title>إصلاح التثبيت على الاستضافة</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Tahoma, Arial; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height:100vh; padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; background: white; border-radius: 10px; padding: 30px; box-shadow: 0 10px 40px rgba(0,0,0,0.3); }
        h1 { color: #667eea; margin-bottom: 20px; text-align: center; }
        .status { padding: 12px; margin-bottom: 10px; border-radius: 6px; border-right: 4px solid #667eea; }
        .status.success { background: #d4edda; border-right-color: #28a745; color: #155724; }
        .status.error { background: #f8d7da; border-right-color: #dc3545; color: #721c24; }
        .status.info { background: #d1ecf1; border-right-color: #17a2b8; color: #0c5460; }
        code { background: #f4f4f4; padding: 2px 6px; border-radius: 3px; direction: ltr; }
    </style>
</head>
<body>
<div class='container'>
<h1>🔧 إصلاح التثبيت</h1>";

// 1. Check and remove .env.local from hosting
if (file_exists($envLocalFile)) {
    // Only warn, don't delete (in case user uploaded it deliberately)
    echo "<div class='status error'>⚠️ تم اكتشاف ملف <code>.env.local</code> على الاستضافة!</div>";
    echo "<div class='status info'>ملف <code>.env.local</code> يجب أن يكون محلياً فقط. يتم تحميل الإعدادات من <code>.env</code> على الاستضافة.</div>";
    
    // Only delete if explicitly requested
    if ($_GET['action'] === 'remove-local') {
        @unlink($envLocalFile);
        echo "<div class='status success'>✓ تم حذف <code>.env.local</code></div>";
    } else {
        echo "<div class='status info'><a href='?action=remove-local' style='color:#0c5460; text-decoration:underline'>اضغط هنا لحذف .env.local</a></div>";
    }
}

// 2. Verify .env exists and is readable
if (!file_exists($envFile)) {
    echo "<div class='status error'>✗ ملف <code>.env</code> غير موجود!</div>";
    
    if (file_exists($envExampleFile)) {
        // Read the example file
        $exampleContent = file_get_contents($envExampleFile);
        if (file_put_contents($envFile, $exampleContent)) {
            echo "<div class='status success'>✓ تم نسخ <code>.env</code> من <code>.env.example</code></div>";
            echo "<div class='status info'>⚠️ تحتاج الآن إلى تحرير <code>.env</code> بإعدادات الاستضافة الصحيحة!</div>";
        } else {
            echo "<div class='status error'>✗ فشل نسخ <code>.env</code> - تحقق من صلاحيات الملفات</div>";
        }
    } else {
        echo "<div class='status error'>✗ ملفات .env و .env.example غير موجودة!</div>";
    }
} else {
    echo "<div class='status success'>✓ ملف <code>.env</code> موجود</div>";
}

// 3. Run migrations
echo \"<h2 style='margin-top:30px; color:#667eea'>تشغيل الترحيلات...</h2>";
try {
    require_once __DIR__ . '/../bootstrap.php';
    
    use Parking\Database;
    use Parking\Installer;
    
    $container = require __DIR__ . '/../bootstrap.php';
    $database = $container['database'];
    
    $installer = new Installer($baseDir);
    $result = $installer->runMigrations($database);
    
    if (empty($result['errors'])) {
        echo \"<div class='status success'>✓ الترحيلات تمت بنجاح</div>\";
        
        if (!empty($result['messages'])) {
            foreach ($result['messages'] as $msg) {
                echo \"<div class='status info'>• $msg</div>\";
            }
        }
        
        // Check final status
        $status = $installer->getStatus(\$database);
        echo \"<h2 style='margin-top:20px; color:#667eea'>الحالة النهائية</h2>\";
        echo \"<div class='status success'>✓ وضعية النظام: \" . strtoupper(\$status['mode']) . \"</div>\";
        
        if (\$status['mode'] === 'installed') {
            echo \"<div class='status success'>
            ✓ النظام جاهز الآن!
            <br><br>
            <a href='home.php' style='color:#155724; font-weight:bold; text-decoration:none'>→ اذهب إلى الصفحة الرئيسية</a>
            </div>\";
        }
    } else {
        foreach (\$result['errors'] as \$err) {
            echo \"<div class='status error'>✗ \$err</div>\";
        }
    }
} catch (Exception \$e) {
    echo \"<div class='status error'>✗ خطأ: \" . \$e->getMessage() . \"</div>\";
}

echo \"</div></body></html>\";
