<?php
session_start();

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Session Test</title>";
echo "<style>body{font-family:Arial;padding:20px;background:#000;color:#0f0;} h1{color:#0ff;} .box{background:#1a1a1a;padding:15px;margin:10px 0;border:2px solid #0f0;} .error{border-color:#f00;color:#f00;} .success{border-color:#0f0;} a{color:#0ff;padding:10px;background:#0066cc;text-decoration:none;border-radius:5px;display:inline-block;margin:5px;}</style>";
echo "</head><body>";

echo "<h1>🔍 Session & Auth Test</h1>";
echo "<p><strong>Time:</strong> " . date('Y-m-d H:i:s') . "</p>";

// Session check
echo "<div class='box success'>";
echo "<h2>Session Status</h2>";
echo "Session ID: " . session_id() . "<br>";
echo "Session Data:<br><pre>" . print_r($_SESSION, true) . "</pre>";
echo "</div>";

// Check Auth
echo "<div class='box'>";
echo "<h2>Auth Check</h2>";

require_once __DIR__ . '/../bootstrap.php';
$database = $GLOBALS['container']['database'];

require_once __DIR__ . '/../src/Auth.php';
$auth = new \Parking\Auth($database);

if ($auth->isLoggedIn()) {
    echo "<div class='success' style='padding:10px;'>✅ LOGGED IN as Admin</div>";
    echo "Admin ID: " . $auth->getAdminId() . "<br>";
    echo "Username: " . $auth->getAdminUsername() . "<br>";
    echo "Full Name: " . $auth->getAdminFullName() . "<br>";
} else {
    echo "<div class='error' style='padding:10px;'>❌ NOT LOGGED IN</div>";
}
echo "</div>";

// Navigation
echo "<div class='box'>";
echo "<h2>Test Navigation</h2>";
echo "<a href='admin-dashboard.php'>Admin Dashboard</a>";
echo "<a href='events.php'>Events</a>";
echo "<a href='clients.php'>Clients</a>";
echo "<a href='coordinators.php'>Coordinators</a>";
echo "<br><br>";
echo "<a href='logout.php' style='background:#dc3545;'>Logout</a>";
echo "<a href='clear-session.php' style='background:#ffc107;color:#000;'>Clear Session</a>";
echo "</div>";

echo "</body></html>";
