<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: text/plain; charset=utf-8');

echo "=== Simple Diagnostic ===\n\n";

echo "PHP Version: " . PHP_VERSION . "\n";
echo "Current file: " . __FILE__ . "\n";
echo "Current dir: " . __DIR__ . "\n\n";

try {
    echo "Step 1: Check if session_init.php exists...\n";
    $sessionFile = __DIR__ . '/session_init.php';
    if (file_exists($sessionFile)) {
        echo "  ✓ File exists\n";
        echo "  Loading...\n";
        require_once $sessionFile;
        echo "  ✓ Loaded successfully\n";
        echo "  Session ID: " . session_id() . "\n";
    } else {
        echo "  ✗ File NOT found!\n";
    }
    
    echo "\nStep 2: Check bootstrap.php...\n";
    $bootstrapFile = dirname(__DIR__) . '/bootstrap.php';
    if (file_exists($bootstrapFile)) {
        echo "  ✓ File exists\n";
        echo "  Loading...\n";
        $container = require $bootstrapFile;
        echo "  ✓ Loaded successfully\n";
    } else {
        echo "  ✗ File NOT found at: $bootstrapFile\n";
    }
    
    echo "\nStep 3: Test database...\n";
    if (isset($container['database'])) {
        $database = $container['database'];
        echo "  ✓ Database object exists\n";
        $pdo = $database->connection();
        echo "  ✓ Connection established\n";
    } else {
        echo "  ✗ No database in container\n";
    }
    
    echo "\n✓ Basic checks passed!\n";
    
} catch (Throwable $e) {
    echo "\n❌ ERROR:\n";
    echo "Type: " . get_class($e) . "\n";
    echo "Message: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "\nTrace:\n" . $e->getTraceAsString() . "\n";
}
