<?php
require_once __DIR__ . '/session_init.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>Test Dashboard Access</title>
</head>
<body>
<h1>Dashboard Access Test</h1>
<pre><?php

echo "=== Step 1: Check Session ===\n";
if (isset($_SESSION['admin_id'])) {
    echo "✓ Admin ID found: " . $_SESSION['admin_id'] . "\n";
    echo "✓ Admin Name: " . ($_SESSION['admin_full_name'] ?? 'N/A') . "\n";
} else {
    echo "✗ No admin_id in session\n";
    echo "→ Would redirect to login.php\n";
    die();
}

echo "\n=== Step 2: Load Bootstrap ===\n";
try {
    $container = require __DIR__ . '/../bootstrap.php';
    $database = $container['database'];
    echo "✓ Bootstrap loaded\n";
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    die();
}

echo "\n=== Step 3: Create Auth ===\n";
try {
    use Parking\Auth;
    $auth = new Auth($database);
    echo "✓ Auth created\n";
    
    if ($auth->isLoggedIn()) {
        echo "✓ Auth says: logged in\n";
        echo "  Full name: " . $auth->getAdminFullName() . "\n";
    } else {
        echo "✗ Auth says: NOT logged in (WHY?!)\n";
        echo "  This is the bug!\n";
    }
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
}

echo "\n=== Step 4: Try requireAuth() ===\n";
try {
    $auth->requireAuth();
    echo "✓ requireAuth() passed - you're logged in!\n";
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
}

echo "\n=== Step 5: Load EventRepository ===\n";
try {
    use Parking\EventRepository;
    $eventRepo = new EventRepository($database);
    $activeEvent = $eventRepo->getActiveEvent();
    echo "✓ EventRepository loaded\n";
    if ($activeEvent) {
        echo "  Active event: " . $activeEvent['name'] . "\n";
    }
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
}

echo "\n=== CONCLUSION ===\n";
echo "If you see this, dashboard SHOULD work!\n";
echo "Try opening: <a href='dashboard.php'>dashboard.php</a>\n";

?></pre>
</body>
</html>
