<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== Test Events Page ===\n";

try {
    echo "1. Loading session_init.php...\n";
    require_once __DIR__ . '/session_init.php';
    echo "   ✓ Session initialized\n";
    
    echo "2. Loading bootstrap...\n";
    $container = require __DIR__ . '/../bootstrap.php';
    $database = $container['database'];
    echo "   ✓ Bootstrap loaded\n";
    
    echo "3. Testing database connection...\n";
    $pdo = $database->connection();
    echo "   ✓ Database connected\n";
    
    echo "4. Creating Auth object...\n";
    use Parking\Auth;
    $auth = new Auth($database);
    echo "   ✓ Auth created\n";
    
    echo "5. Checking login status...\n";
    if ($auth->isLoggedIn()) {
        echo "   ✓ User is logged in\n";
        echo "   Admin ID: " . $auth->getAdminId() . "\n";
        echo "   Admin Name: " . $auth->getAdminFullName() . "\n";
    } else {
        echo "   ✗ User is NOT logged in\n";
        echo "   Session data: " . print_r($_SESSION, true) . "\n";
    }
    
    echo "6. Testing EventRepository...\n";
    use Parking\EventRepository;
    $eventRepo = new EventRepository($database);
    echo "   ✓ EventRepository created\n";
    
    echo "7. Getting active event...\n";
    $activeEvent = $eventRepo->getActiveEvent();
    if ($activeEvent) {
        echo "   ✓ Active event: " . $activeEvent['name'] . "\n";
    } else {
        echo "   ℹ No active event\n";
    }
    
    echo "\n=== ALL TESTS PASSED ===\n";
    
} catch (Exception $e) {
    echo "\n❌ ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "Trace:\n" . $e->getTraceAsString() . "\n";
}
