<?php
// Test what happens when we load index.php step by step
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Index Test</title>";
echo "<style>body{font-family:Arial;padding:20px;} .step{background:#e8f4f8;padding:10px;margin:10px 0;border-left:4px solid #0066cc;} .error{background:#ffe6e6;border-left-color:#cc0000;}</style>";
echo "</head><body><h1>Testing index.php Step by Step</h1>";

echo "<div class='step'><strong>Step 1:</strong> Starting session...</div>";
session_start();
echo "<div class='step'>✓ Session started. ID: " . session_id() . "</div>";

echo "<div class='step'><strong>Step 2:</strong> Loading bootstrap...</div>";
$container = require __DIR__ . '/../bootstrap.php';
$database = $container['database'];
echo "<div class='step'>✓ Bootstrap loaded</div>";

echo "<div class='step'><strong>Step 3:</strong> Checking installation...</div>";
require_once __DIR__ . '/../src/Installer.php';
$installer = new \Parking\Installer(dirname(__DIR__));
$isInstalled = $installer->isInstalled($database);
echo "<div class='step'>✓ Installation check: " . ($isInstalled ? 'INSTALLED' : 'NOT INSTALLED') . "</div>";

if (!$isInstalled) {
    echo "<div class='error'>❌ System thinks it's not installed! This would redirect to install.php</div>";
    echo "<div class='step'>Checking tables...</div>";
    $pdo = $database->connection();
    $stmt = $pdo->query("SHOW TABLES LIKE 'tickets'");
    $exists = $stmt->fetchColumn();
    echo "<div class='step'>Tickets table exists: " . ($exists ? 'YES' : 'NO') . "</div>";
} else {
    echo "<div class='step'>✓ Installation OK - index.php should display normally</div>";
    echo "<div class='step'><a href='index.php' style='padding:10px 20px;background:#0066cc;color:white;text-decoration:none;border-radius:5px;'>Open Real Index.php</a></div>";
}

echo "<hr><h2>Session Data:</h2><pre>";
print_r($_SESSION);
echo "</pre>";

echo "</body></html>";
