<?php
// This file will trace ALL redirects and show what's happening
// Upload to: /home/meezma5/park.meezmart.com/parking/public/trace.php

// Prevent any output buffering
while (ob_get_level()) {
    ob_end_clean();
}

// Override the header function to catch redirects
$redirects = [];
$originalHeader = null;

// Start output
echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Trace Redirects</title>";
echo "<style>body{font-family:monospace;padding:20px;background:#f5f5f5;} .error{color:red;background:#ffe6e6;padding:10px;margin:10px 0;} .info{background:#e6f3ff;padding:10px;margin:10px 0;} pre{background:#fff;padding:10px;overflow:auto;}</style>";
echo "</head><body>";
echo "<h1>🔍 Redirect Trace Tool</h1>";

echo "<div class='info'><strong>Step 1:</strong> Loading bootstrap...</div>";

try {
    // Include bootstrap and track what happens
    ob_start();
    $container = require __DIR__ . '/../bootstrap.php';
    $bootstrapOutput = ob_get_clean();
    
    if (!empty($bootstrapOutput)) {
        echo "<div class='error'><strong>Warning:</strong> Bootstrap produced output:<pre>" . htmlspecialchars($bootstrapOutput) . "</pre></div>";
    } else {
        echo "<div class='info'>✓ Bootstrap loaded cleanly (no output)</div>";
    }
    
    echo "<div class='info'><strong>Step 2:</strong> Checking database connection...</div>";
    $database = $container['database'];
    $pdo = $database->connection();
    echo "<div class='info'>✓ Database connected</div>";
    
    echo "<div class='info'><strong>Step 3:</strong> Checking installer...</div>";
    require_once __DIR__ . '/../src/Installer.php';
    $installer = new \Parking\Installer(dirname(__DIR__));
    $isInstalled = $installer->isInstalled($database);
    echo "<div class='info'>✓ Installation status: " . ($isInstalled ? 'INSTALLED' : 'NOT INSTALLED') . "</div>";
    
    echo "<div class='info'><strong>Step 4:</strong> Checking Auth/Session...</div>";
    session_start();
    
    echo "<div class='info'>";
    echo "Session ID: " . session_id() . "<br>";
    echo "Session Data: <pre>" . print_r($_SESSION, true) . "</pre>";
    echo "</div>";
    
    require_once __DIR__ . '/../src/Auth.php';
    $auth = new \Parking\Auth($database);
    $isLoggedIn = $auth->isLoggedIn();
    
    echo "<div class='info'>✓ Auth check: " . ($isLoggedIn ? 'LOGGED IN' : 'NOT LOGGED IN') . "</div>";
    
    if ($isLoggedIn) {
        echo "<div class='error'><strong>FOUND THE PROBLEM!</strong><br>";
        echo "You are logged in as Admin!<br>";
        echo "Admin ID: " . ($_SESSION['admin_id'] ?? 'N/A') . "<br>";
        echo "<br><a href='clear-session.php' style='padding:10px 20px;background:#dc3545;color:white;text-decoration:none;border-radius:5px;'>Clear Session & Logout</a>";
        echo "</div>";
    }
    
    echo "<h2>All Files Loaded:</h2>";
    echo "<pre>";
    print_r(get_included_files());
    echo "</pre>";
    
} catch (Exception $e) {
    echo "<div class='error'><strong>Error:</strong> " . htmlspecialchars($e->getMessage()) . "</div>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

echo "</body></html>";
